Type ATTimeoutHelperStruct
    nextTimeout As Single
    interval As Single
    enabled As Integer
End Type

DECLARE SUB ATTimeoutHelperInit (r AS ATTimeoutHelperStruct, interval AS SINGLE)
DECLARE FUNCTION ATTimeoutHelperIsTimedOut% (r AS ATTimeoutHelperStruct, autoReset%)

Sub ATTimeoutHelperInit (r As ATTimeoutHelperStruct, interval As Single)
    r.interval = interval
    r.nextTimeout = Timer + (interval / 1000)
    r.enabled = -1
End Sub

Function ATTimeoutHelperIsTimedOut% (r As ATTimeoutHelperStruct, autoReset%)
    If r.enabled Then
        If Timer >= r.nextTimeout Then
            If autoReset% Then
                r.nextTimeout = Timer + (r.interval / 1000)
            End If
            ATTimeoutHelperIsTimedOut% = -1
            Exit Function
        End If
    End If
    ATTimeoutHelperIsTimedOut% = 0
End Function

