            'Universal Editor for A.M.T. Games
    '---------------------------------
    DECLARE SUB create (xpos, ypos, Object)
    DECLARE SUB delete (xpos, ypos)
    DECLARE SUB LoadLevel (LevelNr)
    DECLARE FUNCTION GETKEY$ ()
    DECLARE SUB makewindow (CVAY, CVAX, CVBL, CVBT, Schatten, STYLE)
    '---------------------------------
    CLS
    DIM Sprites(32, 63), Levels%(60, 16, 12), DefSpr(32)
    makewindow 1, 1, 80, 25, 0, 0
    LOCATE 6, 30
    PRINT "  D I V E R "
    LOCATE 9, 30
    PRINT " Leveleditor "
    LOCATE 14, 15
    PRINT "Bitte Grafikmodus whlen: "
    LOCATE 16, 20
    PRINT " 1 - CGA (Color Graphic Adapter)"
    LOCATE 17, 20
    PRINT " 7 - EGA (Enhanced Graphic Adapter)"
    LOCATE 14, 41
    INPUT "", scr
    COLOR 14
    LOCATE 21, 25
    IF scr <> 1 AND scr <> 7 THEN
        PRINT "Unzulssiger Grafikmodus"
        COLOR 7
        END
    END IF
    COLOR 7
    SCREEN scr
    '----------------------------------------------------------------------------
    Game$ = "Diver"
    IF scr = 1 THEN
        gex$ = ".c04"
    ELSE
        gex$ = ".e16"
    END IF
    DEF SEG = VARSEG(Sprites(0, 0))
    BLOAD Game$ + gex$, VARPTR(Sprites(0, 0))
    DEF SEG = VARSEG(Levels%(0, 0, 0))
    BLOAD Game$ + ".lev", VARPTR(Levels%(0, 0, 0))
    DEF SEG
    '----------------------------------------------------------------------------
    LevelNr = 1
    x = 2
    y = 2
    User$ = "ABCDEFGHIJKLMNOP"
    Zeiger$ = "r6g6u5r4d1l3d1r1d1l1r1u1f6e2h6d1f5d1h6d1f5"
    '----------------------------------------------------------------------------
    FOR k = 1 TO 10
        KEY k, CHR$(k)
    NEXT
    '----------------------------------------------------------------------------
    GOSUB panel
    LoadLevel LevelNr
    DO
        GET (x * 16 - 16, y * 16 - 16)-(x * 16 - 16 + 15, y * 16 - 16 + 15), DefSpr
        PSET (x * 16 - 12, y * 16 - 12), 15
        DRAW Zeiger$
        x$ = UCASE$(INPUT$(1))
        PUT (x * 16 - 16, y * 16 - 16), DefSpr, PSET
        IF x$ <> "" AND INSTR(User$, x$) > 0 THEN
            create x, y, INSTR(User$, x$)
        END IF
        IF x$ = " " THEN
            delete x, y
        END IF
        IF x$ = "8" THEN
            IF y > 2 THEN
                y = y - 1
            END IF
        END IF
        IF x$ = "2" THEN
            IF y < 11 THEN
                y = y + 1
            END IF
        END IF
        IF x$ = "4" THEN
            IF x > 2 THEN
                x = x - 1
            END IF
        END IF
        IF x$ = "6" THEN
            IF x < 15 THEN
                x = x + 1
            END IF
        END IF
        IF x$ = CHR$(1) THEN
            IF LevelNr < 60 THEN
                LevelNr = LevelNr + 1
                LOCATE 18, 33
                PRINT "  "; LevelNr;
                LoadLevel LevelNr
                x = 2
                y = 2
            END IF
        END IF
        IF x$ = CHR$(2) THEN
            IF LevelNr > 1 THEN
                LevelNr = LevelNr - 1
                LOCATE 18, 33
                PRINT "  "; LevelNr;
                LoadLevel LevelNr
                x = 2
                y = 2
            END IF
        END IF
        IF x$ = CHR$(3) THEN
            DEF SEG = VARSEG(Levels%(0, 0, 0))
            BSAVE Game$ + ".lev", VARPTR(Levels%(0, 0, 0)), 26962
            DEF SEG
        END IF
        IF x$ = CHR$(8) THEN
            DEF SEG
            CLOSE
            CLS
            SCREEN 0
            WIDTH 80
            END
        END IF
    LOOP
panel:
    LOCATE 1, 33
    PRINT "   F1   ";
    LOCATE 2, 33
    PRINT "nchster";
    LOCATE 3, 33
    PRINT "  Level ";
    LOCATE 5, 33
    PRINT "   F2   ";
    LOCATE 6, 33
    PRINT "vorherg.";
    LOCATE 7, 33
    PRINT "  Level ";
    LOCATE 9, 33
    PRINT "   F3   ";
    LOCATE 10, 33
    PRINT "  Save  ";
    LOCATE 11, 33
    PRINT " Levels ";
    LOCATE 13, 33
    PRINT "   F8   ";
    LOCATE 14, 33
    PRINT "  Quit  ";
    LOCATE 17, 33
    PRINT " Level: ";
    LOCATE 18, 33
    PRINT "  "; LevelNr;
    RETURN

SUB create (xpos, ypos, Object)
    SHARED LevelNr, Levels%(), Sprites()
    PUT (xpos * 16 - 16, ypos * 16 - 16), Sprites(0, Object), PSET
    Levels%(LevelNr, xpos, ypos) = Object
END SUB

SUB delete (xpos, ypos)
    SHARED Levels%(), LevelNr, Sprites()
    PUT (xpos * 16 - 16, ypos * 16 - 16), Sprites(0, 13), PSET
    Levels%(LevelNr, xpos, ypos) = 13
END SUB

FUNCTION GETKEY$
GETKEY1:
    KEYW = 0
    KEY$ = INKEY$
    IF (LEN(KEY$) = 2) THEN
        KEYW = ASC(RIGHT$(KEY$, 1))
    END IF
    IF KEYW = 71 THEN
        UPSLMX$ = "7"
    END IF
    IF KEYW = 72 THEN
        UPSLMX$ = "8"
    END IF
    IF KEYW = 73 THEN
        UPSLMX$ = "9"
    END IF
    IF KEYW = 75 THEN
        UPSLMX$ = "4"
    END IF
    IF KEYW = 77 THEN
        UPSLMX$ = "6"
    END IF
    IF KEYW = 79 THEN
        UPSLMX$ = "1"
    END IF
    IF KEYW = 80 THEN
        UPSLMX$ = "2"
    END IF
    IF KEYW = 81 THEN
        UPSLMX$ = "3"
    END IF
    IF KEYW = 82 THEN
        UPSLMX$ = "0"
    END IF
    IF KEYW = 83 THEN
        UPSLMX$ = "."
    END IF
GETKEYEND:
    IF KEYW = 0 THEN
        UPSLMX$ = KEY$
    END IF
    GETKEY$ = UPSLMX$
END FUNCTION

SUB LoadLevel (LevelNr)
    SHARED Sprites(), Levels%(), MaxDias
    MaxDias = 0
    FOR x = 1 TO 16
        FOR y = 1 TO 12
            IF Levels%(LevelNr, x, y) <> 0 THEN
                PUT (x * 16 - 16, y * 16 - 16), Sprites(0, Levels%(LevelNr, x, y)), PSET
            END IF
            IF Levels%(LevelNr, x, y) = 0 THEN
                LINE (x * 16 - 16, y * 16 - 16)-(x * 16, y * 16), 0, BF
            END IF
        NEXT
    NEXT
END SUB

SUB makewindow (CVAY, CVAX, CVBL, CVBT, Schatten, STYLE)
    IF STYLE = 0 THEN
        OLE$ = CHR$(201)
        ORE$ = CHR$(187)
        ULI$ = CHR$(200)
        URE$ = CHR$(188)
        WAG$ = CHR$(205)
        SER$ = CHR$(186)
    END IF
    IF STYLE = 1 THEN
        OLE$ = CHR$(213)
        ORE$ = CHR$(184)
        ULI$ = CHR$(212)
        URE$ = CHR$(190)
        WAG$ = CHR$(205)
        SER$ = CHR$(179)
    END IF
    IF STYLE = 2 THEN
        OLE$ = CHR$(218)
        ORE$ = CHR$(191)
        ULI$ = CHR$(192)
        URE$ = CHR$(217)
        WAG$ = CHR$(196)
        SER$ = CHR$(179)
    END IF
    IF STYLE = 3 THEN
        OLE$ = CHR$(176)
        ORE$ = CHR$(176)
        ULI$ = CHR$(176)
        URE$ = CHR$(176)
        WAG$ = CHR$(176)
        SER$ = CHR$(176)
    END IF
    IF STYLE = 4 THEN
        OLE$ = CHR$(177)
        ORE$ = CHR$(177)
        ULI$ = CHR$(177)
        URE$ = CHR$(177)
        WAG$ = CHR$(177)
        SER$ = CHR$(177)
    END IF
    IF STYLE = 5 THEN
        OLE$ = CHR$(178)
        ORE$ = CHR$(178)
        ULI$ = CHR$(178)
        URE$ = CHR$(178)
        WAG$ = CHR$(178)
        SER$ = CHR$(178)
    END IF
    IF STYLE = 6 THEN
        OLE$ = CHR$(219)
        ORE$ = CHR$(219)
        ULI$ = CHR$(219)
        URE$ = CHR$(219)
        WAG$ = CHR$(219)
        SER$ = CHR$(219)
    END IF
    FOR T = 1 TO (CVBL - 2)
        SUBHEADER$ = SUBHEADER$ + WAG$
        SUBMIDDLE$ = SUBMIDDLE$ + " "
    NEXT
    LOCATE CVAY, CVAX
    PRINT OLE$; SUBHEADER$; ORE$;
    FOR T = CVAY + 1 TO (CVAY + CVBT - 1)
        LOCATE T, CVAX
        PRINT SER$; SUBMIDDLE$; SER$;
    NEXT
    LOCATE CVAY + (CVBT - 1), CVAX
    PRINT ULI$; SUBHEADER$; URE$;
    IF Schatten = 1 THEN
        COLOR 7, 0
        FOR T = CVAY + 1 TO CVAY + CVBT
            LOCATE T, CVAX + CVBL
            PRINT "  "
        NEXT
        LOCATE CVAY + CVBT, CVAX + 1
        PRINT STRING$(CVBL, 32)
    END IF
END SUB

